/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.vec;

import team.creative.creativecore.common.util.math.vec.VecNd;

public class Vec2d
extends VecNd<Vec2d> {
    public double x;
    public double y;

    public Vec2d() {
    }

    public Vec2d(double x, double y) {
        this.x = x;
        this.y = y;
    }

    public Vec2d(Vec2d vec) {
        super(vec);
    }

    @Override
    public void set(Vec2d vec) {
        this.x = vec.x;
        this.y = vec.y;
    }

    @Override
    public double get(int dim) {
        if (dim == 0) {
            return this.x;
        }
        if (dim == 1) {
            return this.y;
        }
        return 0.0;
    }

    @Override
    public void set(int dim, double value) {
        if (dim == 0) {
            this.x = value;
        } else if (dim == 1) {
            this.y = value;
        }
    }

    @Override
    public int dimensions() {
        return 2;
    }

    @Override
    public Vec2d copy() {
        return new Vec2d(this.x, this.y);
    }

    @Override
    public void add(double x, double y) {
        this.x += x;
        this.y += y;
    }

    @Override
    public void add(Vec2d vec) {
        this.x += this.x;
        this.y += this.y;
    }

    @Override
    public void sub(double x, double y) {
        this.x -= x;
        this.y -= y;
    }

    @Override
    public void sub(Vec2d vec) {
        this.x -= vec.x;
        this.y -= vec.y;
    }

    @Override
    public void scale(double scale) {
        this.x *= scale;
        this.y *= scale;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof Vec2d) {
            return ((Vec2d)obj).x == this.x && ((Vec2d)obj).y == this.y;
        }
        return false;
    }

    @Override
    public boolean epsilonEquals(Vec2d var1, double var2) {
        double var3 = this.x - var1.x;
        if (Double.isNaN(var3)) {
            return false;
        }
        double d = var3 < 0.0 ? -var3 : var3;
        if (d > var2) {
            return false;
        }
        var3 = this.y - var1.y;
        if (Double.isNaN(var3)) {
            return false;
        }
        return (var3 < 0.0 ? -var3 : var3) <= var2;
    }

    @Override
    public double distance(Vec2d vec) {
        double x = this.x - vec.x;
        double y = this.y - vec.y;
        return Math.sqrt(x * x + y * y);
    }

    @Override
    public double distanceSqr(Vec2d vec) {
        double x = this.x - vec.x;
        double y = this.y - vec.y;
        return x * x + y * y;
    }

    @Override
    public double length() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    @Override
    public double lengthSquared() {
        return this.x * this.x + this.y * this.y;
    }

    @Override
    public double angle(Vec2d vec) {
        double vDot = this.dot(vec) / (this.length() * vec.length());
        if (vDot < -1.0) {
            vDot = -1.0;
        }
        if (vDot > 1.0) {
            vDot = 1.0;
        }
        return Math.acos(vDot);
    }

    @Override
    public double dot(Vec2d vec) {
        return this.x * vec.x + this.y * vec.y;
    }
}

